#version 330
#extension GL_EXT_gpu_shader4 : enable
//Apollonianscopic KIFS RemixMod01.fsh  by  Loadus
//https://www.shadertoy.com/view/4ddyD2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.942477  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Apollonianscopic kifs remix

// original creator wyatt, https://www.shadertoy.com/view/Xdcyzl
// Apollonianscopic version gPlatl https://www.shadertoy.com/view/4scyRs

// Tags: apollonian, kifs, fractal, fractal, inversion, koleidoscope

mat3 m;
float k;
mat3 rot (vec3 s) {
	float 	sa = sin(s.x),	ca = cos(s.x),
			sb = sin(s.y),	cb = cos(s.y),
			sc = sin(s.z),	cc = cos(s.z);
	return mat3 (
			vec3(cb*cc, -cb*sc, sb),
			vec3(sa*sb*cc+ca*sc, -sa*sb*sc+ca*cc, -sa*cb),
			vec3(-ca*sb*cc+sa*sc, ca*sb*sc+sa*cc, ca*cb));
}
vec3 app (vec3 v) {
	for (int i = 0; i < 70; i++)
        v = abs(k*m*v/dot(v,v)*0.5-0.5)*2.-1.; 
    return v;
}
vec3 ap (vec3 v) {
	for (int i = 0; i < 15; i++)
        v = abs(k*m*v/dot(v,v)*0.5-0.5)*2.-1.; 
    return v;
}
vec3 norm (vec3 p) {
		vec2 e = vec2 (.05,0.);
    	vec3 g = ap(p);
		return normalize(vec3(
				ap(p+e.xyy).x - g.x,
				ap(p+e.yxy).y - g.y,
				ap(p+e.yyx).z - g.z));
}

float SCurve (float value, float amount, float correction) {

	float curve = 1.0; 

    if (value < 0.5)
    {

        curve = pow(value, amount) * pow(2.0, amount) * 0.5; 
    }
        
    else
    { 	
    	curve = 1.0 - pow(1.0 - value, amount) * pow(2.0, amount) * 0.5; 
    }

    return pow(curve, correction);
}

const float PI = 3.14159265359;

//----------------------------------------------------------------
void smallKoleidoscope(inout vec2 uv, float ka)
{
  float angle = abs (mod (atan (uv.x, uv.y), 2.0 * ka) - ka) + 0.01*iTime;
  uv = length(uv) * vec2(cos(angle), sin(angle));
}
//----------------------------------------------------------------
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{	
    vec2 uv = gl_FragCoord.xy/iResolution.xy*2.-1.;
    uv.x *= iResolution.x/iResolution.y;

    vec2 mp = iMouse.xy / iResolution.xy;
    uv *= 0.2 + 10. * mp.x;
    float sideCount = 1.0 + round(mp.y * 11.0);
    smallKoleidoscope (uv, PI / sideCount);
    
    float t = 0.015*iTime;
    m = rot(t+vec3(2,3,5));
    k = 1.3+0.1*sin(0.08*iTime);
    vec3 v = (.5+0.25*sin(0.03*iTime))*m*vec3(2.*uv,0);
    vec3 col = sin(app(v))*0.5+0.5;
    col = col*0.8+0.2*(sin(norm(v))*0.5+0.5);
    
    	float gm = 1.0/2.22;
    	col = vec3(pow(col.r, gm), pow(col.g, gm), pow(col.b, gm));
    	col.r = SCurve(col.g * 0.3 + col.r * 0.7, 4.0, 2.0);
    	col.g = SCurve(col.g * 0.7 + col.b * 0.3, 2.0, 2.0);
    	col.b = col.g * 0.3 + col.b * 0.7;
    
    gl_FragColor = vec4(col,1.0);
}